﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

namespace Chapitre_11_5
{
    class GamePadService : GameComponent, IGamePadService
    {
        GamePadState lastGPState;
        GamePadState GPState;

        public GamePadService(Game game)
            : base(game)
        {
            ServiceHelper.Add<IGamePadService>(this);
        }

        public bool IsButtonDown(Buttons button)
        {
            return GPState.IsButtonDown(button);
        }

        public bool ButtonHasBeenPressed(Buttons button)
        {
            return lastGPState.IsButtonDown(button) && GPState.IsButtonUp(button);
        }

        public override void Update(GameTime gameTime)
        {
            lastGPState = GPState;

            GPState = GamePad.GetState(PlayerIndex.One);

            base.Update(gameTime);
        }
    }
}
